FUNCTION_BLOCK fbCodeBank
(*
{CSY}Blok pro ukldn a ovovn kd
{ENU}Block for storing and checking codes
*)
  VAR_INPUT
    Check     : BOOL R_EDGE; //{CSY}Ovit kd{ENU}Check code
    New       : BOOL R_EDGE; //{CSY}Nauit se nov kd{ENU}Learn new code
    Del       : BOOL R_EDGE; //{CSY}Vymazat kd{ENU}Delete code
    NewAction : USINT;       //{CSY}Akce piazen k novmu kdu{ENU}Action assigned to new code
    N         : USINT;       //{CSY}Poet kd v poli Codes{ENU}Number of items in the Codes array
  END_VAR
  VAR_OUTPUT
    Done   : BOOL;   //{CSY}Oven/nauen/vymazn spn ukoneno{ENU}Checking/learning/deleting finished successfully
    Err    : BOOL;   //{CSY}Oven/nauen/vymazn s chybou{ENU}Checking/learning/deleting finished with error
    Action : USINT;  //{CSY}Akce piazen ovenmu kdu{ENU}Action assigned to checked code
  END_VAR
  VAR_IN_OUT
    Code  : TCodeString11; //{CSY}Kd k oven/nauen/vymazn{ENU}
    Codes : T11DigitsCode; //{CSY}Prvn poloka pole kd{ENU}
  END_VAR
  VAR
  END_VAR
  VAR_TEMP
    pCode      : PTR_TO T11DigitsCode;
    pCodeLast  : PTR_TO T11DigitsCode;
  END_VAR
  
  Err  := 0;
  Done := 0;
  
  pCode     := ADR(Codes);
  pCodeLast := pCode + USINT_TO_UDINT(N)*sizeof(T11DigitsCode);
  
  IF Check OR New OR Del THEN
    Action := 0;
    WHILE PTR_TO_UDINT(pCode) <> PTR_TO_UDINT(pCodeLast) DO
      IF pCode^.Code = Code THEN
        IF Check THEN
          Action := pCode^.Action;
        END_IF;
        EXIT;
      END_IF;
      pCode := pCode + sizeof(T11DigitsCode);
    END_WHILE;
    Done := Check;
  END_IF;
  
  IF New THEN
    IF pCode^.Code = Code THEN
      Done   := true;
      pCode^.Action := NewAction;
      RETURN;
    END_IF;
    pCode     := ADR(Codes);
    WHILE PTR_TO_UDINT(pCode) <> PTR_TO_UDINT(pCodeLast) DO
      IF pCode^.Action = 0 THEN
        Done   := true;
        pCode^.Action := NewAction;
        pCode^.Code := Code;
        RETURN;
      END_IF;
      pCode := pCode + sizeof(T11DigitsCode);
    END_WHILE;
    Err := 1;
  ELSIF Del THEN
    IF pCode^.Code = Code THEN
       pCode^.Action := 0;
       Done   := true;
       RETURN;
    END_IF;
    Err:= 1;
  END_IF;

END_FUNCTION_BLOCK

