FUNCTION_BLOCK fbPinKeyboardACM08E
(*
{CSY}Blok pro obsluhu klvesnice ACM08E
{ENU}Block for handling of keyboard ACM08E
*)
  VAR_INPUT
    Authorized : BOOL R_EDGE; //{CSY}Psknut pi povolenm pstupu{ENU}Beep when access is authorized
    Denied     : BOOL R_EDGE; //{CSY}Psknut pi odmtnutm pstupu{ENU}Beep when access is denied
    Beep       : BOOL;        //{CSY}Pskan pi odasovn{ENU}Beep for timeout
    In         : TCIB_CWG0503S_CODE; //{CSY}Vstupn struktura C-WG-0503S CODE{ENU}C-WG-0503S CODE input structure
  END_VAR
  VAR_OUTPUT
    NewCode : BOOL; //{CSY}Byl pijat nov kd{ENU}New code accepted
    Out : TCIB_DO3; //{CSY}Vstup pro bzuk{ENU}Output for beeper
  END_VAR
  VAR_IN_OUT
    Code : TCodeString11; //{CSY}etzec s kdem karty nebo kdem zadanm z klvesnice{ENU}String containing card code or code input from keyboard
  END_VAR
  VAR
    TP1 : TP := (PT := T#1000ms);
    TP2 : TP := (PT := T#3000ms);
    TP3 : TP := (PT := T#200ms);
    TC1 : fbTick := (PT := T#1000ms);
    OldStat : USINT;
    i : USINT;
  END_VAR
  VAR_TEMP
    Num : USINT;
    NegTPQ : BOOL;
    PosTPQ : BOOL;
  END_VAR

  Num := BYTE_TO_USINT(SHR(USINT_TO_BYTE(In.VAL[0]),4));

  IF NewCode THEN
    NewCode := false;
    Code := '';
  END_IF;

  IF OldStat <> In.STAT THEN
    OldStat := In.Stat;
    IF In.STAT = 1 THEN
      IF Num < 10 THEN
        Code := Code + USINT_TO_STRING(Num);
      ELSIF Num = 10 THEN
        Code := '';
      ELSIF Num = 11 THEN
        NewCode := true;
      END_IF;
    ELSIF In.STAT > 0 AND In.STAT <= 5 THEN
      Code := 'C';
      FOR i := 0 TO In.STAT-1 DO
        Code := Code + USINT_TO_STRINGF(in := In.VAL[i], format := '%02X');
      END_FOR;
      NewCode := true;
    END_IF;
  END_IF;

  TP1(IN := Authorized);
  TP2(IN := Denied);
  TC1(IN := Beep);
  TP3(IN := TC1.Q);
  
  PosTPQ := TP1.Q AND (TP1.ET > T#250ms);
  NegTPQ := TP2.Q AND (TP2.ET > T#300ms AND TP2.ET < T#600ms OR
                       TP2.ET > T#900ms AND TP2.ET < T#1200ms OR
                       TP2.ET > T#1500ms AND TP2.ET < T#1800ms);
  
  Out.DO1 := PosTPQ OR NegTPQ OR TP3.Q;
  Out.DO2 := PosTPQ OR NegTPQ OR TP3.Q;


END_FUNCTION_BLOCK

